/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// LSecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "LSecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLSecDialog dialog


CLSecDialog::CLSecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CLSecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLSecDialog)
	m_lLength = 0.0;
	m_lThickness = 0.0;
	m_lWidth = 0.0;
	m_lExtHeight = 0.0;
	m_blendRadius = 0.0;
	m_check1 = FALSE;
	//}}AFX_DATA_INIT
}


void CLSecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLSecDialog)
	DDX_Text(pDX, IDC_LEDIT1, m_lLength);
	DDX_Text(pDX, IDC_LEDIT2, m_lThickness);
	DDX_Text(pDX, IDC_LEDIT3, m_lWidth);
	DDX_Text(pDX, IDC_LEDIT4, m_lExtHeight);
	DDX_Text(pDX, IDC_LEDIT5, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLSecDialog, CDialog)
	//{{AFX_MSG_MAP(CLSecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLSecDialog message handlers

void CLSecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	ISet *objset1 = NULL;
	UpdateData(TRUE);
	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_lLength >0 && m_lThickness > 0 && m_lWidth > 0 && m_lExtHeight > 0
		&& m_lThickness < m_lLength && m_lThickness < m_lWidth) {
		
		status = CreateLSection(m_lLength/1000, m_lThickness/1000, m_lWidth/1000, m_lExtHeight/1000,
			m_blendRadius/1000, &objset1);
		if(status || !objset1){
			AfxMessageBox("CreateLSection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
